; ASSEMBLER ASIDE 1.14
;          .Z80
ENDFIL:    EQU       0                  ; :FILL FULL ALLOCATION
;****************************************************************
;         Format N8VEMram disk B - 2008 J Moxham                  *
; modified with JR loops so can be relocated anywhere in ram    *
;                                                               *
;****************************************************************

MPCL_RAM: EQU       078H                ;RAM CONTROL PORT
MPCL_ROM: EQU       07CH                ;ROM CONTROL PORT

RAMTOP:             EQU       0FFFFH              ;HIGHEST ADDRESSABLE MEMORY LOCATION
RAMBOTTOM:          EQU       08000H              ;START OF FIXED UPPER 32K PAGE OF 512KB x 8 RAM 8000H-FFFFH
MONSTARTCOLD:       EQU       0F800H              ;COLD START MONITOR IN HIGH RAM

TMPBUF:   EQU       09000H              ;TEMPORARY BUFFER

          org       0100H
          ld        hl,FMTRAM ;MOVE FORMATTER TO HIGH MEMORY
          ld        de,TMPBUF
          ld        bc,FMTRAME-FMTRAM
          ldir

          jp        TMPBUF              ;GO FORMAT

FMTRAM:   LD        A,080H              ;SWITCH ROM OUT
          OUT       (MPCL_ROM),A
          LD        A,1                 ;FORMAT PAGE 1-14
FORM_MEM_LOOP:
          OUT       (MPCL_RAM),A        ;SELECT CURRENT RAM PAGE
          LD        HL,00000H ;START OF RAM PAGE
          LD        BC,07FFFH ;LENGTH OF RAM PAGE
          ld        e,l
          ld        d,h
          inc       de
          ld        (hl),A
          ldir
                    
          INC       A                   ;SELECT NEXT RAM PAGE
          CP        15                  ;DONE?
          JR        NZ,FORM_MEM_LOOP;NO, CONTINUE
                    
          LD        A,1                 ;SELECT RAM PAGE 1
          OUT       (MPCL_RAM),A
          LD        HL,02800H ;FILL DIRECTORY SECTORS WITH 0E5H
          LD        BC,00400H ;LENGTH OF DIRECTORY
          LD        A,0E5H
          ld        e,l
          ld        d,h
          inc       de
          ld        (hl),A
          ldir
                    
          LD        HL,TMPBUF+(RAMDPB-FMTRAM)     ;COPY DPB TO RAM DISK
          LD        DE,080H
          LD        BC,15
          LDIR
                    
          XOR       A                   ;SELECT RAM PAGE 0
          OUT       (MPCL_RAM),A
          JP        0EA03H              ;WARM BOOT CPM
                    
RAMDPB:
          DEFW        16                  ;SPT = 16 - NEW RAM DPB
          DEFB        4                   ;BSH = 4
          DEFB        15                  ;BLM = 15, BLS = 2048
          DEFB        1                   ;EXM = 1
          DEFW        219                 ;DSM = 219
          DEFW        255                 ;DRM = 255
          DEFB        011110000B          ;AL0 = 0F0H
          DEFB        000000000B          ;AL1 = 0
          DEFW        0                   ;CKS = 0
          DEFW        5                   ;OFF = 5  

FMTRAME:

          IF       ENDFIL
          ORG       004FFH
          DEFB        055H
          ENDIF
          END

