; ASSEMBLER ASIDE 1.14
;          .Z80
ENDFIL:    EQU       0                   ;FILL FULL LOADER SIZE
;***********************************
;*        Loader version 0.3
;*        Based on work by Andrew Lynch and James Moxham
;*        Version 0.5 - Bill Beech NJ7P
;*        Version 0.5A - for 59K CP/M
;***********************************

RAMPAG:   EQU       078H                ;IO ADDRESS OF RAM PAGE LATCH
ROMPAG:   EQU       07CH                ;IO ADDRESS OF ROM PAGE LATCH

RAMTOP:   EQU       0FFFFH              ;HIGHEST ADDRESSABLE MEMORY LOCATION

MONROM:   EQU       00200H              ;Where the Monitor is stored in ROM
MONRAM:   EQU       0FC00H              ;Where the Monitor starts in RAM (entry point)
MONSIZ:   EQU       00400H              ;Monitor is 1KB in length

CPMROM:   EQU       00600H              ;Where the CCP+BDOS+BIOS is stored in ROM
CPMRAM:   EQU       0D000H              ;Where the CCP+BDOS+BIOS starts in RAM (entry point)
CPMSIZ:   EQU       02400H              ;CCP+BDOS+BIOS length

          ORG       00000H

          DI                            ;Disable interrupts
          LD        SP,RAMTOP ;INITAL STACKPOINTER

          LD        HL,MONROM ;LOAD MONITOR FROM BOOT DRIVE INTO RAM
          LD        DE,MONRAM
          LD        BC,MONSIZ
          LDIR

          LD        HL,CPMROM ;LOAD CP/M FROM BOOT DRIVE INTO RAM
          LD        DE,CPMRAM
          LD        BC,CPMSIZ
          LDIR
          
;         JP        MONRAM    ;START THE MONITOR
          JP        0E600H
          
          IF        ENDFIL
          ORG       000FFH
          DEFB        055H
          ENDIF
          END
