.z80
; ASSEMBLER ASIDE 1.14
;          .Z80
ENDFIL:    EQU       0                   ;FILL FULL LOADER SIZE
;***********************************
;*        Loader version 0.3
;*        Based on work by Andrew Lynch and James Moxham
;*        Version 0.3 - Bill Beech NJ7P
;***********************************

RAMPAG:   EQU       078H                ;IO ADDRESS OF RAM PAGE LATCH
ROMPAG:   EQU       07CH                ;IO ADDRESS OF ROM PAGE LATCH

RAMTOP:   EQU       0FFFFH              ;HIGHEST ADDRESSABLE MEMORY LOCATION

MONROM:   EQU       00100H              ;Where the Monitor is stored in ROM
MONRAM:   EQU       0FC00H              ;Where the Monitor starts in RAM (entry point)
MONSIZ:   EQU       00400H              ;Monitor is 1KB in length

CPMROM:   EQU       00500H              ;Where the CCP+BDOS+BIOS is stored in ROM
CPMRAM:   EQU       0D000H              ;Where the CCP+BDOS+BIOS starts in RAM (entry point)
CPMSIZ:   EQU       02400H              ;CCP+BDOS+BIOS length

TMPBUF:   EQU       09000H              ;TEMPORARY BUFFER

          ORG       00000H

          DI                            ;Disable interrupts
          LD        SP,RAMTOP ;INITAL STACKPOINTER

          LD        HL,MONROM ;LOAD MONITOR FROM BOOT DRIVE INTO RAM
          LD        DE,MONRAM
          LD        BC,MONSIZ
          LDIR

          LD        HL,CPMROM ;LOAD CP/M FROM BOOT DRIVE INTO RAM
          LD        DE,CPMRAM
          LD        BC,CPMSIZ
          LDIR
          
          LD        HL,RAMFIX ;COPY RAM DPB LOADER TO HIGH MEMORY
          LD        DE,TMPBUF
          LD        BC,RAMFIXE-RAMFIX
          LDIR
                    
          JP        TMPBUF
          
RAMFIX:   LD        A,080H              ;DESELECT ROM
          OUT       (ROMPAG),A
          LD        A,1                 ;SELECT RAM PAGE 1
          OUT       (RAMPAG),A
          LD        HL,TMPBUF+(RAMDPB-RAMFIX)     ;COPY RAM DPB TO RAM
          LD        DE,080H
          LD        BC,15
          LDIR
                    
          JP        MONRAM    ;START THE MONITOR
          
;         RAM DISK DPB        
RAMDPB:   
          DEFW        16                  ;SPT = 16 - NEW RAM DPB
          DEFB        4                   ;BSH = 4
          DEFB        15                  ;BLM = 15, BLS = 2048
          DEFB        1                   ;EXM = 1
          DEFW        219                 ;DSM = 219
          DEFW        255                 ;DRM = 255
          DEFB        011110000B          ;AL0 = 0F0H
          DEFB        000000000B          ;AL1 = 0
          DEFW        0                   ;CKS = 0
          DEFW        5                   ;OFF = 5  
RAMFIXE:

;         ORG       00080H              ;27256 ROM DPB
;         ROM DISK DPB        
;         DEFW        16                  ;SPT = 16
;         DEFB        3                   ;BSH = 3
;         DEFB        7                   ;BLM = 7, BLS = 1024
;         DEFB        0                   ;EXM = 0
;         DEFW        21                  ;DSM = 21
;         DEFW        31                  ;DRM = 31
;         DEFB        010000000B          ;AL0 = 080H
;         DEFB        000000000B          ;AL1 = 0
;         DEFW        0                   ;CKS = 0
;         DEFW        5                   ;OFF = 5  

          IF        ENDFIL
          ORG       000FFH
          DEFB        055H
          ENDIF
          END
