; 10.01.2009 HR
; Assembler ASIDE 1.14
; c't 8504
; dart_sio_ct8504
; Testprogramm fuer die I/O-Karte in Z80-Mnemonics
;
;;BASE:     EQU    000H                  ; 4 DIL-SCHALTER
BASE:     EQU    0F0H                  ; 4 DIL-SCHALTER

CTC:      EQU    BASE+00H              ;
CTC0:     EQU    BASE+0                ; ZAEHLER 0
CTC1:     EQU    BASE+1                ; ZAEHLER 1
CTC2:     EQU    BASE+2                ; ZAEHLER 2
CTC3:     EQU    BASE+3                ; ZAEHLER 3

SIO:      EQU    BASE+4H               ;
SIOAD:    EQU    SIO+0                 ; KANAL A DATEN
SIOBD:    EQU    SIO+1                 ; KANAL B DATEN
SIOAC:    EQU    SIO+2                 ; KANAL A CONT.
SIOBC:    EQU    SIO+3                 ; KANAL B CONT.

PIO1:     EQU    BASE+08H              ;
PIO1A:    EQU    PIO1+0                ; PIO 1 A DATEN
PIO1B:    EQU    PIO1+1                ; PIO 1 B DATEN
PIO1AC:   EQU    PIO1+2                ; PIO 1 A CONT.
PIO1BC:   EQU    PIO1+3                ; PIO 1 B CONT.

PIO2:     EQU    BASE+0CH              ;
PIO2A:    EQU    PIO2+0                ; PIO 2 A DATEN
PIO2B:    EQU    PIO2+1                ; PIO 2 B DATEN
PIO2AC:   EQU    PIO2+2                ; PIO 2 A CONT.
PIO2BC:   EQU    PIO2+3                ; PIO 2 B CONT.

          ORG      100H                ; PROGRAMM FUER CP/M 80

START:
          LD        C,SIOAC            ;LOAD DART CONTROL PORT A ADDRESS INTO REGISTER C

          LD        A,18H              ;RESET BYTE
          OUT       (C),A              ;RESET CHANNEL A

          LD        A,12H              ;POINTER TO WR3
          OUT       (C),A
          LD        A,%00000000        ;INTERRUPT VECTOR
          OUT       (C),A              ;

          LD        A,04H              ;POINTER FOR WR4
          OUT       (C),A
          LD        A,%11000100        ;BIT DEFINITIONS FOR ASYNCHRONOUS COMMUNICATIONS
                                       ;PARITY DISABLE
                                       ;NO PARITY
                                       ;1 STOP BIT/CHARACTER
                                       ;X64 CLOCK MODE
          OUT       (C),A              ;SPECIFY PARITY, STOP BITS, CLOCK MULTIPLIER

          LD        A,11H              ;POINTER TO WR1
          OUT       (C),A
          LD        A,00H              ;BYTE TO DISABLE INTERRUPTS
          OUT       (C),A              ;DISABLE INTERRUPTS

          LD        A,03H              ;POINTER TO WR3
          OUT       (C),A
          LD        A,%11000001        ;BIT DEFINITIONS FOR RECEIVER
          OUT       (C),A              ;ENABLE RECEIVER TO RECEIVE 8-BIT CHARACTER

          LD        A,05H              ;POINT TO WR5
          OUT       (C),A
          LD        A,%01101010        ;BIT DEFINITIONS FOR TRANSMITTER
          OUT       (C),A              ;ENABLE TRANSMITTER TO TRANSMIT 8-BIT CHARACTER

          LD        A,10h              ;RESET ext/stat int's AGAIN
          OUT       (C),A              ;





          LD        C,SIOBC            ;LOAD DART CONTROL PORT B ADDRESS INTO REGISTER C

          LD        A,18H              ;RESET BYTE
          OUT       (C),A              ;RESET CHANNEL B

          LD        A,12H              ;POINTER TO WR3
          OUT       (C),A
          LD        A,%00000000        ;INTERRUPT VECTOR
          OUT       (C),A              ;

          LD        A,04H              ;POINTER FOR WR4
          OUT       (C),A
          LD        A,%11000100        ;BIT DEFINITIONS FOR ASYNCHRONOUS COMMUNICATIONS
                                       ;PARITY DISABLE
                                       ;NO PARITY
                                       ;1 STOP BIT/CHARACTER
                                       ;X64 CLOCK MODE
          OUT       (C),A              ;SPECIFY PARITY, STOP BITS, CLOCK MULTIPLIER

          LD        A,11H              ;POINTER TO WR1
          OUT       (C),A
          LD        A,00H              ;BYTE TO DISABLE INTERRUPTS
          OUT       (C),A              ;DISABLE INTERRUPTS

          LD        A,03H              ;POINTER TO WR3
          OUT       (C),A
          LD        A,%11000001        ;BIT DEFINITIONS FOR RECEIVER
          OUT       (C),A              ;ENABLE RECEIVER TO RECEIVE 8-BIT CHARACTER

          LD        A,05H              ;POINT TO WR5
          OUT       (C),A
          LD        A,%01101010        ;BIT DEFINITIONS FOR TRANSMITTER
          OUT       (C),A              ;ENABLE TRANSMITTER TO TRANSMIT 8-BIT CHARACTER

          LD        A,10h              ;RESET ext/stat int's AGAIN
          OUT       (C),A              ;



;         RET

TRNSMT:
STATUS:   IN        A,(SIOBC)          ;READ REGISTER RR0
          BIT       2,A                ;CHECK TRANSMITTER BUFFER IF IT IS EMPTY
          JR        Z,STATUS           ;WAIT UNTIL BUFFER IS EMPTY
          LD        A,'B'              ;LOAD CHARACTER 'B' ASCII 42H
          OUT       (SIOBD),A          ;SEND THE CHARACTER

;         RET


SIOIN:
;          IN     A,(SIOBC)    ; STATUS LESEN
;          AND    00000001B    ; RX CHAR. VORHANDEN ?
;          RET    Z            ; KEIN CHAR.
          IN     A,(SIOBD)    ;
          AND    01111111B    ; BIT 7 = 0
          CP     '.'
          JP     Z,EXIT      ; EXIT
          LD     C,A

SIOOUT:
          IN     A,(SIOBC)    ; STATUS LESEN
          BIT    2,A          ; TX SENDEPUFFER LEER ?
          JR     Z,SIOOUT     ; NEIN
          LD     A,C          ; CHAR.
          OUT    (SIOBD),A    ; SENDEN



          JP        STATUS             ;REPEAT FOREVER


EXIT:
          IN     A,(SIOBD)    ;
          JP     0000H        ;



          END

